using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class GameManager : MonoBehaviour
{
   public static GameManager instance;

    int currentPlayer = 1;

   bool activeTurn = true;

   public GameObject redCoin;
   public GameObject yellowCoin;

   void Awake()
    {
        instance = this;
    }

    void Start()
    {

    }

    public void ColumnPressed(int column)
    {
        if(!activeTurn)
        {
            Debug.Log("Wait");
            return;
        }
        int y = Playfield.instance.ValidMove(column);
        if(y != -1)
        {
            StartCoroutine(PlayCoin(y, column));
        }
    }
    IEnumerator PlayCoin(int row, int column)
    {
        activeTurn = false;

        GameObject coin = Instantiate((currentPlayer == 1?redCoin:yellowCoin)) as GameObject;
        coin.transform.position = new Vector3(startPoint.position.x + column,startPoint.position.y + 1,startPoint.position.z);

        Vector3 goalPos = new Vector3(startPoint.position.x + column,startPoint.position.y - row,startPoint.position.z);

        while(MoveToGoal(goalPos, coin))
        {
            yield return null;
        }

        Playfield.instance.DropCoin(row, column, currentPlayer);

    }

    public void WinCondition(bool winner)
    {
        if(winner)
        {

        }

        else
        {
            activeTurn = true;
            SwitchPlayer();
        }
    }

    bool MoveToGoal(Vector3 goalPos, GameObject coin)
    {
        return goalPos != (coin.transform.position = Vector3.MoveTowards(coin.transform.position, goalPos, 5f * Time.deltaTime));
    }

    void SwitchPlayer()
    {
        currentPlayer = (currentPlayer == 1) ? 2 : 1;

    }
}
